<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Agent extends Model 
{

    protected $table = 'agents';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('firstName', 'lastName', 'matricule', 'email', 'image');

    public function qrCode()
    {
        return $this->hasOne('App\Models\QrCode', 'qrcode');
    }

    public function entity()
    {
        return $this->belongsTo('App\Models\Entity');
    }

}